import usePreferences from './usePreferences';

const useTrunc = () => {
    const { preference: { decimal_digits, thousand_separator } = {} } =
        usePreferences();
    let decimalSeparator = thousand_separator == '.' ? ',' : '.';
    let decimalDigit = Number(decimal_digits);
    let x = Number('1'.toString().padEnd(decimalDigit + 1, '0'));
    const trunc = (value) => {
        let truncValue = Math.trunc(Number(value) * x) / x;
        let [beforeDecimalDigit, afterDecimalDigit] =
            String(truncValue).split(decimalSeparator);

        if (afterDecimalDigit?.length < decimalDigit) {
            afterDecimalDigit =
                afterDecimalDigit + ''.toString().padEnd(decimalDigit - 1, '0');
        }
        let result = `${beforeDecimalDigit}${
            afterDecimalDigit ? decimalSeparator + afterDecimalDigit : ''
        }`;
        return result;
    };
    return trunc;
};

export default useTrunc;
